﻿using System;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data.Queues
{
    public enum GroupCallCoordinatorType
    {
        CallStarted,
        CallResponded,
    }

    public class GroupCallCoordinator : BaseGroupEndpointNotification<GroupCallCoordinator>
    {
        public GroupCallCoordinator() {}

        public GroupCallCoordinator(Group group)
            : base(group)
        {
            
        }

        public int SenderID { get; set; }
        public GroupCallCoordinatorType Type { get; set; }
        public Guid TargetGroupID { get; set; }
        public CallDetails CallDetails { get; set; }
        public CallRespondedNotification CallRespondedNotification { get; set; }

        public static void CallStarted(int senderID, Group group, CallDetails callDetails)
        {
            GroupHostManager.EnsureServiceHost(group.RootGroup);

            new GroupCallCoordinator(group.RootGroup)
            {
                SenderID = senderID,
                TargetGroupID = group.GroupID,
                CallDetails = callDetails,
                Type = GroupCallCoordinatorType.CallStarted

            }.Enqueue();

        }

        public static void CallResponded(Group group, CallDetails callDetails, CallRespondedNotification callRespondedNotification)
        {
            GroupHostManager.EnsureServiceHost(group.RootGroup);

            new GroupCallCoordinator(group.RootGroup)
            {
                TargetGroupID = group.GroupID,
                CallDetails = callDetails,
                CallRespondedNotification = callRespondedNotification,
                Type = GroupCallCoordinatorType.CallResponded

            }.Enqueue();

        }
    }
}
