﻿using Curse.Friends.NotificationContracts;


namespace Curse.Friends.Data.Queues
{
    /// <summary>
    /// Notifier which is processed by NotificationServer to send the contract to all the clients
    /// that are currently online.
    /// </summary>
    public class GroupChangeNotifier : BaseClientEndpointNotification<GroupChangeNotifier>
    {
        public GroupChangeNotifier() {  }

        public GroupChangeNotification Notification { get; set; }        

        /// <summary>
        /// UserID of the requestor to be displayed in client
        /// </summary>
        public int SenderID
        {
            get;
            set;
        }

        public GroupChangeNotifier(ClientEndpoint endpoint)
            : base(endpoint)
        {

        }

        public static void Create(ClientEndpoint endpoint, GroupChangeNotification notification)
        {            
            new GroupChangeNotifier(endpoint)
            {               
                Notification = notification
            }.Enqueue();
        }
    }
}
