﻿using System;
using System.Linq;
using Curse.CloudQueue;
using Curse.Friends.Data.Search;

namespace Curse.Friends.Data
{
    [CloudQueueProcessor(4, true)]
    [CloudQueue(true)]
    public class GroupEventWorker : BaseCloudQueueShoveledMessage<GroupEventWorker>
    {
        public GroupEvent[] Events { get; set; }

        public static void Create(GroupEvent groupEvent)
        {
            new GroupEventWorker
            {
                Events = new []{groupEvent}
            }.Enqueue();
        }

        public static void Create(GroupEvent[] groupEvents)
        {
            new GroupEventWorker
            {
                Events = groupEvents
            }.Enqueue();
        }

        public static void StartProcessor()
        {
            StartProcessor(Process);
        }

        private static void Process(GroupEventWorker worker)
        {
            try
            {
                if (worker.Events == null || !worker.Events.Any())
                {
                    return;
                }

                GroupEventManager.Index(worker.Events);
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Failed to index group event(s).", worker.Events);
            }
        }
    }
}
