﻿using System;
using System.Collections.Generic;
using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    public enum GroupGiveawayCoordinatorType
    {
        Start,
        End,
        AddParticipant,
        RemoveParticipant,
        Roll,
        Claim,
        Continue,
        Deactivate
    }

    public class GroupGiveawayCoordinator : BaseCloudQueueRoutedMessage<GroupGiveawayCoordinator>
    {
        public GroupGiveawayCoordinatorType ChangeType { get; set; }

        public Guid GroupID { get; set; }

        public int GiveawayID { get; set; }

        public GroupMember Requestor { get; set; }

        public GroupGiveawayParticipant AffectedParticipant { get; set; }

        public HashSet<int> Roles { get; set; }

        public GroupGiveawayCoordinator()
        {

        }

        private GroupGiveawayCoordinator(GroupGiveaway giveaway, GroupGiveawayCoordinatorType changeType) : base(giveaway.MachineName, giveaway.RegionID)
        {
            GroupID = giveaway.GroupID;
            GiveawayID = giveaway.GiveawayID;
            ChangeType = changeType;
        }

        public static void StartGiveaway(GroupGiveaway giveaway, GroupMember requestor, HashSet<int> autoEnterRoles)
        {
            GroupGiveawayHostManager.EnsureServiceHost(giveaway);
            new GroupGiveawayCoordinator(giveaway, GroupGiveawayCoordinatorType.Start)
            {
                Roles = autoEnterRoles,
                Requestor = requestor
            }.Enqueue();
        }

        public static void EndGiveaway(GroupGiveaway giveaway, GroupMember requestor)
        {
            GroupGiveawayHostManager.EnsureServiceHost(giveaway);
            new GroupGiveawayCoordinator(giveaway, GroupGiveawayCoordinatorType.End)
            {
                Requestor = requestor
            }.Enqueue();
        }

        public static void AddParticipant(GroupGiveaway giveaway, GroupMember requestor, GroupGiveawayParticipant participant)
        {
            GroupGiveawayHostManager.EnsureServiceHost(giveaway);
            new GroupGiveawayCoordinator(giveaway, GroupGiveawayCoordinatorType.AddParticipant)
            {
                AffectedParticipant = participant,
                Requestor = requestor
            }.Enqueue();
        }

        public static void RemoveParticipant(GroupGiveaway giveaway, GroupMember requestor, GroupGiveawayParticipant participant)
        {
            GroupGiveawayHostManager.EnsureServiceHost(giveaway);
            new GroupGiveawayCoordinator(giveaway, GroupGiveawayCoordinatorType.RemoveParticipant)
            {
                AffectedParticipant = participant,
                Requestor = requestor
            }.Enqueue();
        }

        public static void Roll(GroupGiveaway giveaway, GroupMember requestor)
        {
            GroupGiveawayHostManager.EnsureServiceHost(giveaway);
            new GroupGiveawayCoordinator(giveaway, GroupGiveawayCoordinatorType.Roll)
            {
                Requestor = requestor
            }.Enqueue();
        }

        public static void Claim(GroupGiveaway giveaway, GroupMember member, GroupGiveawayParticipant participant)
        {
            GroupGiveawayHostManager.EnsureServiceHost(giveaway);
            new GroupGiveawayCoordinator(giveaway, GroupGiveawayCoordinatorType.Claim)
            {
                AffectedParticipant = participant,
                Requestor = member
            }.Enqueue();
        }

        public static void ContinueGiveaway(GroupGiveaway giveaway, GroupMember requestor)
        {
            GroupGiveawayHostManager.EnsureServiceHost(giveaway);
            new GroupGiveawayCoordinator(giveaway, GroupGiveawayCoordinatorType.Continue)
            {
                Requestor = requestor
            }.Enqueue();
        }

        public static void DeactivateGiveaway(GroupGiveaway giveaway, GroupMember requestor)
        {
            GroupGiveawayHostManager.EnsureServiceHost(giveaway);
            new GroupGiveawayCoordinator(giveaway, GroupGiveawayCoordinatorType.Deactivate)
            {
                Requestor = requestor
            }.Enqueue();
        }
    }
}
