﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Data.Queues;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public class GroupGiveawayMultiSessionNotifier : BaseSessionNotification<GroupGiveawayMultiSessionNotifier>
    {
        public GroupGiveawayChangedNotification Notification { get; set; }

        public GroupGiveawayMultiSessionNotifier()
        {
            
        }

        public GroupGiveawayMultiSessionNotifier(HashSet<string> sessionIDs, string serverName, int regionID) : base(sessionIDs, serverName, regionID)
        {

        }

        public static void Create(GroupGiveawayChangedNotification notification , HashSet<string> sessions, string serverName , int regionID)
        {
            new GroupGiveawayChangedMultiSessionNotifier(notification, sessions, serverName, regionID).Enqueue();
        }
    }

    public class GroupGiveawayChangedMultiSessionNotifier : BaseMultiSessionNotifier<GroupGiveawayChangedNotification>
    {
        public GroupGiveawayChangedMultiSessionNotifier(GroupGiveawayChangedNotification notification, HashSet<string> sessionIDs, string serverName, int regionID)
            : base(notification, sessionIDs, serverName, regionID)
        {
        }
    }
}
