﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Data.Queues;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public class GroupGiveawayNotificationCoordinator : BaseGroupEndpointNotification<GroupGiveawayNotificationCoordinator>
    {
        public GroupGiveawayChangedNotification Notification { get; set; }

        public int? TargetUserID { get; set; }

        public GroupGiveawayNotificationCoordinator()
        {
        }

        public GroupGiveawayNotificationCoordinator(Group group) : base(group)
        {
            
        }

        public static void Create(Group group, GroupGiveawayChangedNotification notification, int? targetUserID = null)
        {
            GroupHostManager.EnsureServiceHost(group);
            new GroupGiveawayNotificationCoordinator(group)
            {
                Notification = notification,
                TargetUserID = targetUserID
            }.Enqueue();
        }
    }
}
