﻿using System;
using Curse.CloudQueue;
using Curse.Logging;
using Newtonsoft.Json;

namespace Curse.Friends.Data.Queues
{
    [CloudQueueProcessor(4, true)]
    public class GroupIntegrityWorker : BaseCloudQueueWorkerMessage<GroupIntegrityWorker>
    {
        private new static readonly LogCategory Logger = new LogCategory("GroupIntegrityWorker");

        [JsonConstructor]
        public GroupIntegrityWorker() { }

        protected GroupIntegrityWorker(Guid rootGroupID)
        {
            RootGroupID = rootGroupID;
        }

        public Guid RootGroupID { get; set; }

        public static void Create(Group group)
        {
            if (group == null)
            {
                throw new ArgumentNullException("group");
            }

            if (!group.IsRootGroup)
            {
                throw new ArgumentException("Group integrity check can only be run against the root group.");
            }

            new GroupIntegrityWorker(group.GroupID).Enqueue();
        }
    }

}
