﻿using Curse.Friends.Data.Queues;

namespace Curse.Friends.Data
{
    public class GroupMemberTwitchAccountCoordinator : BaseGroupEndpointNotification<GroupMemberTwitchAccountCoordinator>
    {
        public int UserID { get; set; }

        public ExternalAccount ExternalAccount { get; set; }

        public GroupMemberTwitchAccountCoordinator()
        {
            
        }

        private GroupMemberTwitchAccountCoordinator(Group group) : base(group)
        {
            
        }

        public static void Create(Group group, int userID, ExternalAccount account)
        {
            GroupHostManager.EnsureServiceHost(group);
            new GroupMemberTwitchAccountCoordinator(group)
            {
                UserID = userID,
                ExternalAccount = account
            }.Enqueue();
        }
    }
}
