﻿using System;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data.Queues
{
    public class GroupMessageChangeCoordinator : BaseGroupEndpointNotification<GroupMessageChangeCoordinator>
    {
        public GroupMessageChangeCoordinator() {}

        public GroupMessageChangeCoordinator(Group group)
            : base(group)
        {
            
        }

        public Guid TargetGroupID { get; set; }
        public ConversationMessageNotification Notification { get; set; }

        public static void Create(Group group, ConversationMessageNotification notification)
        {
            GroupHostManager.EnsureServiceHost(group.RootGroup);

            new GroupMessageChangeCoordinator(group.RootGroup)
            {
                TargetGroupID = group.GroupID,
                Notification = notification,

            }.Enqueue();

        }
    }
}
