﻿using System;
using Curse.Friends.NotificationContracts;
using Curse.CloudQueue;

namespace Curse.Friends.Data.Queues
{
    [CloudQueueProcessor(24, false)]
    public class GroupMessageCordinator : BaseGroupEndpointNotification<GroupMessageCordinator>
    {
        public GroupMessageCordinator() {}

        public GroupMessageCordinator(Group group)
            : base(group)
        {
            
        }
     
        public int SenderID
        {
            get;
            set;
        }

        public ConversationMessageRequest MessageRequest
        {
            get; 
            set;
        }

        public DateTime Timestamp
        {
            get; 
            set;
        }

        public Guid TargetGroupID { get; set; }

        public Attachment Attachment { get; set; }

        public ClientEndpoint SenderEndpoint { get; set; }

        public static void Create(Group group, ConversationMessageRequest message, int senderID, ClientEndpoint senderEndpoint, Attachment attachment = null)
        {
            GroupHostManager.EnsureServiceHost(group.RootGroup);

            new GroupMessageCordinator(group.RootGroup)
            {                                
                TargetGroupID = group.GroupID,
                MessageRequest = message,
                SenderID = senderID,
                Timestamp = DateTime.UtcNow,
                Attachment = attachment,
                SenderEndpoint = senderEndpoint

            }.Enqueue();
            
        }
    }
}
