﻿
namespace Curse.Friends.Data.Queues
{
    public class GroupMessageLikeCoordinator : BaseGroupEndpointNotification<GroupMessageLikeCoordinator>
    {
        public GroupMessageLikeCoordinator() {}

        public GroupMessageLikeCoordinator(Group group)
            : base(group)
        {
            
        }

        public int UserID { get; set; }
        public string ConversationID { get; set; }
        public string ConversationMessageID { get; set; }
        public long ConversationMessageTimestamp { get; set; }
        
        public static void Create(Group group, int userID, string conversationID, string conversationMessageID, long timestamp)
        {
            GroupHostManager.EnsureServiceHost(group.RootGroup);

            new GroupMessageLikeCoordinator(group.RootGroup)
            {
                UserID = userID,
                ConversationID = conversationID,
                ConversationMessageID = conversationMessageID,
                ConversationMessageTimestamp = timestamp,                
            }.Enqueue();
        }
    }
}
