﻿using System;

namespace Curse.Friends.Data.Queues
{
    public class GroupMessageReadCoordinator : BaseGroupEndpointNotification<GroupMessageReadCoordinator>
    {
        public GroupMessageReadCoordinator() {}

        public GroupMessageReadCoordinator(Group group)
            : base(group)
        {
            
        }

        public Guid AffectedGroupID { get; set; }        
        public int UserID { get; set; }
        public DateTime MessageTimestamp { get; set; }

        public static void Create(Group group, int userID, DateTime messageTimestamp)
        {
            GroupHostManager.EnsureServiceHost(group.RootGroup);

            new GroupMessageReadCoordinator(group.RootGroup)
            {
                UserID = userID,                               
                MessageTimestamp = messageTimestamp,
                AffectedGroupID = group.GroupID
            }.Enqueue();
        }
    }
}
