﻿using System.Collections.Generic;
using Curse.Friends.NotificationContracts;


namespace Curse.Friends.Data.Queues
{
    /// <summary>
    /// Notifier which is processed by NotificationServer to send the contract to all the clients
    /// that are currently online.
    /// </summary>
    public class GroupMultiSessionChangeNotifier : BaseSessionNotification<GroupMultiSessionChangeNotifier>
    {
        public GroupMultiSessionChangeNotifier() {  }

        public GroupChangeNotification Notification { get; set; }

        public GroupMultiSessionChangeNotifier(GroupChangeNotification notification, HashSet<string> sessionIDs, string serverName, int regionID)
            : base(sessionIDs, serverName, regionID)
        {
            Notification = notification;
        }

        public static void Create(GroupChangeNotification notification, HashSet<string> sessionIDs, string serverName, int regionID)
        {
            new GroupChangeMultiSessionNotifier(notification, sessionIDs, serverName, regionID).Enqueue();
        }
    }

    public class GroupChangeMultiSessionNotifier : BaseMultiSessionNotifier<GroupChangeNotification>
    {
        public GroupChangeMultiSessionNotifier(GroupChangeNotification notification, HashSet<string> sessionIDs, string serverName, int regionID) : base(notification, sessionIDs, serverName, regionID)
        {
        }
    }
}
