﻿using System.Collections.Generic;
using Curse.Friends.Data.Queues;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public class GroupMultiSessionMessageNotifier : BaseSessionNotification<GroupMultiSessionMessageNotifier>
    {
        public GroupMultiSessionMessageNotifier() { }

        public GroupMultiSessionMessageNotifier(ConversationMessageNotification messageNotification, HashSet<string> sessionIDs, string serverName, int regionID)
            : base(sessionIDs, serverName, regionID)
        {
            Message = messageNotification;
        }

        public ConversationMessageNotification Message { get; set; }

        public static void Create(ConversationMessageNotification message, HashSet<string> sessionIDs, string serverName, int regionID)
        {
            new GroupMessageMultiSessionNotifier(message, sessionIDs, serverName, regionID).Enqueue();
        }
    }

    public class GroupMessageMultiSessionNotifier : BaseMultiSessionNotifier<ConversationMessageNotification>
    {
        public GroupMessageMultiSessionNotifier(ConversationMessageNotification notification, HashSet<string> sessionIDs, string serverName, int regionID)
            : base(notification, sessionIDs, serverName, regionID)
        {
        }
    }
}
