﻿using Curse.CloudQueue;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public class GroupPollChangedCommunityCoordinator : BaseCloudQueueRoutedMessage<GroupPollChangedCommunityCoordinator>
    {
        public string ExternalID { get; set; }

        public GroupPollChangedNotification Notification { get; set; }
        
        public GroupPollChangedCommunityCoordinator()
        {
        }

        private GroupPollChangedCommunityCoordinator(ExternalCommunity community)
        {
            community.EnsureHost();
            DestinationServerName = community.MachineName;
            DestinationRegionID = community.RegionID;
            ExternalID = community.ExternalID;
        }

        public static void Create(ExternalCommunity community, GroupPollChangedNotification notification)
        {
            new GroupPollChangedCommunityCoordinator(community)
            {
                Notification = notification
            }.Enqueue();
        }
    }
}
