﻿using Curse.Friends.Data.Queues;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public class GroupPollChangedCoordinator : BaseGroupEndpointNotification<GroupPollChangedCoordinator>
    {
        public GroupPollChangedNotification Notification { get; set; }

        public GroupPollChangedCoordinator()
        {
        }

        private GroupPollChangedCoordinator(Group group)
            : base(group)
        {
            DestinationServerName = group.MachineName;
            DestinationRegionID = group.RegionID;
        }

        public static void Create(Group group, GroupPollChangedNotification notification)
        {
            GroupHostManager.EnsureServiceHost(group);

            new GroupPollChangedCoordinator(group)
            {
                Notification = notification
            }.Enqueue();
        }
    }
}
