﻿using System;
using Curse.CloudQueue;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    public class GroupPollCoordinator : BaseCloudQueueRoutedMessage<GroupPollCoordinator>
    {
        public Guid GroupID { get; set; }

        public int RequestorID { get; set; }

        public int PollID { get; set; }

        public GroupPollChangeType ChangeType { get; set; }

        public GroupPollCoordinator()
        {
        }

        private GroupPollCoordinator(GroupPoll poll):base(poll.MachineName,poll.RegionID)
        {
            GroupID = poll.GroupID;
            PollID = poll.PollID;
        }

        public static void Create(GroupMember requestor, GroupPoll poll, GroupPollChangeType changeType)
        {
            GroupPollHostManager.EnsureServiceHost(poll);

            new GroupPollCoordinator(poll)
            {
                ChangeType = changeType,
                RequestorID = requestor.UserID
            }.Enqueue();
        }

        public static void VoteChanged(GroupPoll poll)
        {
            GroupPollHostManager.EnsureServiceHost(poll);

            new GroupPollCoordinator(poll)
            {
                ChangeType = GroupPollChangeType.VotesUpdated,
            }.Enqueue();
        }
    }
}
