﻿using System.Collections.Generic;
using Curse.Friends.Data.Queues;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public class GroupPollMultiSessionChangedNotifier : BaseSessionNotification<GroupPollMultiSessionChangedNotifier>
    {
        public GroupPollChangedNotification Notification { get; set; }

        public GroupPollMultiSessionChangedNotifier()
        {
        }

        public GroupPollMultiSessionChangedNotifier(HashSet<string> sessions, string serverName, int regionID)
            : base(sessions, serverName, regionID)
        {
        }

        public static void Create(GroupPollChangedNotification notification, HashSet<string> sessions, string serverName, int regionID)
        {
            new GroupPollChangedMultiSessionNotifier(notification, sessions, serverName, regionID).Enqueue();
        }
    }

    public class GroupPollChangedMultiSessionNotifier : BaseMultiSessionNotifier<GroupPollChangedNotification>
    {
        public GroupPollChangedMultiSessionNotifier(GroupPollChangedNotification notification, HashSet<string> sessionIDs, string serverName, int regionID)
            : base(notification, sessionIDs, serverName, regionID)
        {
        }
    }
}
