﻿using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data.Queues
{
    public class GroupPreferenceChangedNotifier : BaseClientEndpointNotification<GroupPreferenceChangedNotifier>
    {
        public GroupPreferenceChangedNotifier()
        { }

        public GroupPreferenceChangedNotifier(ClientEndpoint endpoint):
            base(endpoint)
        { }

        public GroupPreferenceNotification Notification { get; set; }

        /// <summary>
        /// Create GroupPreference notification that will be sent to all connected endpoints of users
        /// </summary>
        public static void Create(ClientEndpoint endpoint, GroupMember membership)
        {
            var notification = new GroupPreferenceNotification()
            {
                GroupID = membership.GroupID,
                Preference = membership.NotificationPreference,
                IsFavorite = membership.IsFavorite
            };
            new GroupPreferenceTargetedNotifier(notification, endpoint).Enqueue();
        }
    }

    public class GroupPreferenceTargetedNotifier : BaseTargetedNotifier<GroupPreferenceNotification>
    {
        public GroupPreferenceTargetedNotifier(GroupPreferenceNotification notification, ClientEndpoint endpoint) : base(notification, endpoint)
        {
        }
    }
}
