﻿using Curse.Friends.NotificationContracts;
using System;

namespace Curse.Friends.Data.Queues
{
    public class GroupPrivateMessageCoordinator : BaseGroupEndpointNotification<GroupPrivateMessageCoordinator>
    {
        public GroupPrivateMessageCoordinator() {}

        public GroupPrivateMessageCoordinator(Group group)
            : base(group)
        {
            
        }
     
        public int SenderID
        {
            get;
            set;
        }

        public int RecipientID
        {
            get;
            set;
        }

        public ConversationMessageRequest MessageRequest
        {
            get; 
            set;
        }

        public DateTime Timestamp
        {
            get; 
            set;
        }

       
        public Attachment Attachment { get; set; }

        public ClientEndpoint SenderEndpoint { get; set; }

        public static void Create(Group group, ConversationMessageRequest message, int senderID, int recipientID, ClientEndpoint senderEndpoint, Attachment attachment = null)
        {
            GroupHostManager.EnsureServiceHost(group.RootGroup);

            new GroupPrivateMessageCoordinator(group.RootGroup)
            {                                                
                MessageRequest = message,
                SenderID = senderID,
                RecipientID = recipientID,
                Timestamp = DateTime.UtcNow,
                Attachment = attachment,
                SenderEndpoint = senderEndpoint

            }.Enqueue();
            
        }
    }
}
