﻿using System;
using System.Collections.Generic;
using Curse.CloudQueue;
using Curse.Logging;
using Curse.SocketMessages;
using Newtonsoft.Json;

namespace Curse.Friends.Data.Queues
{
    [CloudQueue(false)]
    [CloudQueueProcessor(64, false)]
    public class MultiSessionNotifier : BaseCloudQueueRoutedMessage<MultiSessionNotifier>
    {
        public HashSet<string> SessionIDs { get; set; }

        public string SerializedMessage { get; set; }

        public MultiSessionNotifier()
        {

        }

        private MultiSessionNotifier(string serialized, HashSet<string> sessionIDs, string machineName, int regionID) : base(machineName, regionID)
        {
            SessionIDs = sessionIDs;
            SerializedMessage = serialized;
        }

        private static readonly LogCategory Logger = new LogCategory("MultiSessionNotifier")
        {
            Throttle = TimeSpan.FromMinutes(1)
        };

        public static void Create<T>(T contract, HashSet<string> sessionIDs, string machineName, int regionID) where T : Contract<T>
        {
            var type = Contract<T>.MessageType;

            if (sessionIDs.Count > 500)
            {
                Logger.Warn("Attempt to queue a message with more than 500 recipients: " + typeof(T).Name, new { SessionCount = sessionIDs.Count, machineName, regionID });
            }

            var serialized = JsonConvert.SerializeObject(new
            {
                TypeID = type,
                Body = contract
            });

            new MultiSessionNotifier(serialized, sessionIDs, machineName, regionID).Enqueue();
        }
    }
}
