﻿
using System;
using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    public class UserActivityResolver : BaseCloudQueueShoveledMessage<UserActivityResolver>
    {
        public UserActivityResolver()
        {

        }

        public UserActivityResolver(int regionID) : base(regionID)
        {

        }

        public int UserID { get; set; }

        public string MachineKey { get; set; }

        public static void Create(int regionID, int userID, string machineKey)
        {
            new UserActivityResolver(regionID)
            {
                UserID = userID,
                MachineKey = machineKey
            }.Enqueue();
        }
    }
}
