﻿using Curse.CloudQueue;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    public class UserPresenceResolver : BaseCloudQueueShoveledMessage<UserPresenceResolver>
    {
        public UserPresenceResolver()
        {

        }

        public UserPresenceResolver(int regionID) : base(regionID)
        {

        }

        public int UserID { get; set; }

        public string MachineKey { get; set; }

        public UserConnectionStatus? RequestedOverride { get; set; }

        public bool DisconnectEndpoint { get; set; }

        public string SessionID { get; set; }

        public string ConnectionID { get; set; }

        public static void CreateAvailabilityOverrideResolver(int userID, int regionID, string machineKey, UserConnectionStatus newOverride)
        {
            new UserPresenceResolver(regionID)
            {
                UserID = userID,
                MachineKey = machineKey,
                RequestedOverride = newOverride,
            }.Enqueue();
        }

        public static void CreateAvailabilityResolver(int userID, int regionID, string machineKey)
        {
            new UserPresenceResolver(regionID)
            {
                UserID = userID,
                MachineKey = machineKey
            }.Enqueue();
        }

        /// <summary>
        /// When a user's session is not found, or the server starts up.        
        /// </summary>
        /// <param name="endpoint"></param>
        public static void CreateDisconnectResolver(ClientEndpoint endpoint)
        {
            // Kick this off in the endpoint's region - where the change takes place - instead of
            // the user's home region
            new UserPresenceResolver(endpoint.RegionID)
            {
                UserID = endpoint.UserID,
                MachineKey = endpoint.MachineKey,
                SessionID = endpoint.SessionID,
                DisconnectEndpoint = true,
                ConnectionID = endpoint.ConnectionID,
            }.Enqueue();
        }
    }
}
