﻿using System;
using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    [CloudQueueProcessor(4, true)]
    public class PrivateMessageWorker : BaseCloudQueueWorkerMessage<PrivateMessageWorker>
    {

        public int SenderID { get; set; }
        public string SenderMachineKey { get; set; }
        public string ConversationID { get; set; }
        public string Body { get; set; }
        public Guid ClientMessageID { get; set; }
        public Attachment Attachment { get; set; }
        
        public static void Create(int senderID, string senderMachineKey, string conversationID, string body, Guid clientMessageID, Attachment attachment)
        {
            new PrivateMessageWorker
            {
                SenderID = senderID,
                SenderMachineKey = senderMachineKey,
                ConversationID = conversationID,
                Body = body,
                ClientMessageID = clientMessageID,
                Attachment = attachment
            }.Enqueue();
        }
    }
}
