﻿using System;
using Curse.Friends.Data.Queues;
using Curse.Friends.Enums;

namespace Curse.Friends.Data
{
    public class RoleSyncCoordinator : BaseLockableMessage<RoleSyncCoordinator>
    {
        public string ExternalCommunityID { get; set; }

        public int UserID { get; set; }

        public GroupRoleTag RoleType { get; set; }
        
        public int SourceRegionID { get; set; }

        public string SourceMachineName { get; set; }

        public bool IsEligible { get; set; }


        public RoleSyncCoordinator()
        {
            
        }

        public RoleSyncCoordinator(string destinationServerName, int destinationRegionID, Guid requestID) : base(destinationServerName, destinationRegionID, requestID)
        {
        }

        public static void CreateRequest(string destinationServerName, int destinationRegionID, int userID, string externalCommunityID, GroupRoleTag roleType, Guid requestID)
        {
            new RoleSyncCoordinator(destinationServerName,destinationRegionID, requestID)
            {
                ExternalCommunityID = externalCommunityID,
                UserID = userID,
                RoleType = roleType,
                SourceMachineName = Environment.MachineName,
                SourceRegionID = GroupGiveaway.LocalConfigID
            }.Enqueue();
        }

        public static void CreateResponse(RoleSyncCoordinator request, bool isEligible)
        {
            new RoleSyncCoordinator(request.SourceMachineName, request.SourceRegionID, request.RequestID)
            {
                SourceRegionID = request.DestinationRegionID,
                SourceMachineName = request.DestinationServerName,
                ExternalCommunityID = request.ExternalCommunityID,
                UserID = request.UserID,
                RoleType = request.RoleType,
                IsEligible = isEligible
            }.Enqueue();
        }
    }
}
