﻿using System.Collections.Generic;
using Curse.CloudQueue;
using Curse.SocketMessages;
using Newtonsoft.Json;

namespace Curse.Friends.Data.Queues
{
    [CloudQueue(false)]
    [CloudQueueProcessor(64, false)]
    public sealed class SingleSessionNotifier : BaseClientEndpointNotification<SingleSessionNotifier>
    {
        public HashSet<string> SessionIDs { get; set; }

        public string SerializedMessage { get; set; }

        public SingleSessionNotifier()
        {

        }

        private SingleSessionNotifier(string serializedMessage, ClientEndpoint endpoint) : base(endpoint)
        {
            SerializedMessage = serializedMessage;
        }

        public static void Create<T>(Contract<T> contract, ClientEndpoint endpoint)
        {
            var type = Contract<T>.MessageType;
            var serialized = JsonConvert.SerializeObject(new
            {
                TypeID = type,
                Body = contract
            });

            new SingleSessionNotifier(serialized, endpoint).Enqueue();
        }
    }
}
