﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.Aerospike;
using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    public enum TwitchAccountResolverType
    {
        UserLink,
        HostChange
    }

    public class TwitchAccountResolver : BaseCloudQueueWorkerMessage<TwitchAccountResolver>
    {
        public TwitchAccountResolverType Type { get; set; }

        public ExternalAccount TwitchAccount { get; set; }

        public int UserID { get; set; }

        public static void UserLinkChanged(int userID, ExternalAccount account)
        {
            new TwitchAccountResolver
            {
                Type = TwitchAccountResolverType.UserLink,
                UserID = userID,
                TwitchAccount = account
            }.Enqueue();
        }

        public static void HostChanged(ExternalAccount account)
        {
            new TwitchAccountResolver
            {
                Type = TwitchAccountResolverType.HostChange,
                TwitchAccount = account
            }.Enqueue();
        }

        public static void StartProcessor()
        {
            StartProcessor(Process);
        }

        private static void Process(TwitchAccountResolver resolver)
        {
            int[] userIDs;
            switch (resolver.Type)
            {
                case TwitchAccountResolverType.HostChange:
                    userIDs = resolver.TwitchAccount.MappedUsers.ToArray();
                    break;
                case TwitchAccountResolverType.UserLink:
                    userIDs = new[] {resolver.UserID};
                    break;
                default:
                    Logger.Error("Unsupported Twitch Account Resolver Type");
                    return;
            }

            foreach (var userID in userIDs)
            {
                var memberships = GroupMember.GetAllLocal(g => g.UserID, userID).Where(m => !m.IsDeleted);
                var allGroups = Group.MultiGetLocal(new HashSet<Guid>(memberships.Select(m => m.GroupID)).Select(id => new KeyInfo(id)));

                foreach (var group in allGroups.Where(g => !string.IsNullOrEmpty(g.MachineName)))
                {
                    GroupMemberTwitchAccountCoordinator.Create(group, userID, resolver.TwitchAccount);
                }
            }
        }
    }
}
