﻿using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    [CloudQueue(false)]
    [CloudQueueProcessor(64, true)]
    public class TwitchAccountSyncWorker : BaseCloudQueueShoveledMessage<TwitchAccountSyncWorker>
    {
        public string TwitchID { get; set; }
        public bool BypassThrottle { get; set; }

        public static void Create(string twitchID, bool bypassThrottle = false)
        {
            new TwitchAccountSyncWorker
            {
                TwitchID = twitchID,
                BypassThrottle = bypassThrottle
            }.Enqueue();
        }
    }
}
