﻿using Curse.Friends.Data.Queues;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public class TwitchChatNoticeCoordinator : BaseGroupEndpointNotification<TwitchChatNoticeCoordinator>
    {
        public int[] NotificationTargets { get; set; }

        public TwitchChatNoticeNotification Notification { get; set; }

        public TwitchChatNoticeCoordinator()
        {
            
        }

        private TwitchChatNoticeCoordinator(Group group) : base(group)
        {
            
        }

        public static void Create(Group group, TwitchChatNoticeNotification notification, int[] notificationTargets = null)
        {
            GroupHostManager.EnsureServiceHost(group);
            new TwitchChatNoticeCoordinator(group)
            {
                NotificationTargets = notificationTargets,
                Notification = notification
            }.Enqueue();
        }
    }
}
