﻿using Curse.CloudQueue;

namespace Curse.Friends.Data.Queues
{
    [CloudQueue(false)]
    [CloudQueueProcessor(4, false)]
    public class TwitchCommunityModsWorker : BaseCloudQueueWorkerMessage<TwitchCommunityModsWorker>
    {
        public string TwitchID { get; set; }

        public bool ForceSync { get; set; }

        public static void Create(ExternalCommunity community, bool forceSync = false)
        {
            new TwitchCommunityModsWorker
            {
                TwitchID = community.ExternalID,
                ForceSync = forceSync
            }.Enqueue();
        }
    }
}
