﻿using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    [CloudQueue(false)]
    [CloudQueueProcessor(4, false)]
    public class TwitchCommunitySubscriptionsWorker : BaseCloudQueueShoveledMessage<TwitchCommunitySubscriptionsWorker>
    {
        public string TwitchID { get; set; }

        public bool ForceFullSync { get; set; }

        public TwitchCommunitySubscriptionsWorker()
        {
            
        }

        public TwitchCommunitySubscriptionsWorker(int regionID) : base(regionID)
        {
            
        }

        public static void Create(ExternalCommunity community, bool forceFullSync = false)
        {
            new TwitchCommunitySubscriptionsWorker(community.RegionID > 0 ? community.RegionID : 1)
            {
                TwitchID = community.ExternalID,
                ForceFullSync = forceFullSync
            }.Enqueue();
        }
    }
}
