﻿using System;
using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    [CloudQueue(false)]
    [CloudQueueProcessor(4, false)]
    public class TwitchServerRoleWorker : BaseCloudQueueWorkerMessage<TwitchServerRoleWorker>
    {
        public int UserID { get; set; }

        public Guid ServerID { get; set; }

        public static void Create(int userID, Guid serverID)
        {
            new TwitchServerRoleWorker
            {
                UserID = userID,
                ServerID = serverID
            }.Enqueue();
        }
    }
}
