﻿using Curse.CloudQueue;

namespace Curse.Friends.Data
{
    [CloudQueue(false)]
    [CloudQueueProcessor(4, false)]
    public class TwitchUserFollowsWorker : BaseCloudQueueWorkerMessage<TwitchUserFollowsWorker>
    {
        public string TwitchID { get; set; }

        public bool ForceFullSync { get; set; }

        public static void Create(ExternalAccount account, bool forceFullSync = false)
        {
            new TwitchUserFollowsWorker
            {
                TwitchID = account.ExternalID,
                ForceFullSync = forceFullSync
            }.Enqueue();
        }
    }
}
