﻿using Curse.Friends.Data.Queues;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public class UserBanStatusNotifier : BaseTargetedNotifier<UserBanStatusNotification>
    {
        private UserBanStatusNotifier(UserBanStatusNotification notification, ClientEndpoint endpoint) : base(notification, endpoint)
        {
            
        }

        public static void Create(ClientEndpoint endpoint, UserBanStatusNotification notification)
        {
            new UserBanStatusNotifier(notification, endpoint).Enqueue();
        }

        public static void Create(ClientEndpoint endpoint, UserBanType bans)
        {
            var notification = new UserBanStatusNotification
            {
                UserID = endpoint.UserID,
                Bans = bans
            };
            Create(endpoint, notification);
        }
    }
}
