﻿using Curse.Friends.Data.Queues;
using Curse.Friends.NotificationContracts;

namespace Curse.Friends.Data
{
    public class UserClientSettingsNotifier : BaseClientEndpointNotification<UserClientSettingsNotifier>
    {
        public UserClientSettingsNotification Notification { get; set; }

        public UserClientSettingsNotifier()
        {
        }

        public UserClientSettingsNotifier(ClientEndpoint ep) : base(ep)
        {
        }

        public static void Create(ClientEndpoint ep, UserClientSettingsNotification settings)
        {
            new UserClientSettingsTargetedNotifier(settings, ep).Enqueue();
        }
    }

    public class UserClientSettingsTargetedNotifier : BaseTargetedNotifier<UserClientSettingsNotification>
    {
        public UserClientSettingsTargetedNotifier(UserClientSettingsNotification notification, ClientEndpoint endpoint) : base(notification, endpoint)
        {
        }
    }
}
