﻿using System;
using Curse.CloudQueue;

namespace Curse.Friends.Data.Queues
{
    [CloudWorkerQueue(0)]
    [CloudQueueProcessor(8, true)]
    [CloudQueue(true)]
    public class UserRegionChangeWorker : BaseCloudQueueWorkerMessage<UserRegionChangeWorker>
    {
        public int UserID { get; set; }
        public int NewRegionID { get; set; }

        public static void Create(int userID, int newRegionID)
        {

            if (userID <= 0)
            {
                throw new ArgumentException("Must supply valid user ID", nameof(userID));
            }
            

            if (newRegionID <= 0)
            {
                throw new ArgumentException("Must supply valid new region ID", nameof(newRegionID));
            }

            new UserRegionChangeWorker
            {
                UserID = userID,                
                NewRegionID = newRegionID
            }.Enqueue();
        }
    }
}
