﻿using Curse.CloudQueue;
using Curse.Friends.Enums;

namespace Curse.Friends.Data.Queues
{
    [CloudQueue(true)]
    [CloudQueueProcessor(4, true)]
    public class UserReportWorker : BaseCloudQueueWorkerMessage<UserReportWorker>
    {
        public UserReportType Type { get; set; }
        public UserReportReason Reason { get; set; }
        public int SourceUserID { get; set; }
        public int TargetUserID { get; set; }
        public string Description { get; set; }

        public static void Create(int sourceUserID, UserReportType type, UserReportReason reason, int targetUserID, string description)
        {
            new UserReportWorker { SourceUserID = sourceUserID, Type = type, Reason = reason, TargetUserID = targetUserID, Description = description }.Enqueue();
        }
    }
}
