﻿
using Curse.CloudQueue;

namespace Curse.Friends.Data.Queues
{
    public enum VoicePermissionsWorkerType
    {
        MemberRoleChanged,
        ChannelPermissionsChanged,
        RolePermissionsChanged
    }

    [CloudQueueProcessor(4, true)]
    [CloudQueue(true)]
    public class VoicePermissionsWorker : BaseCloudQueueShoveledMessage<VoicePermissionsWorker>
    {
        public VoicePermissionsWorkerType Type { get; set; }

        public Group RootGroup { get; set; }

        public Group Channel { get; set; }

        public int UserID { get; set; }

        public VoicePermissionsWorker()
        {
            
        }

        public VoicePermissionsWorker(int region) : base(region)
        {
            
        }

        public static void CreateMemberRoleChanged(Group rootGroup, int userID)
        {
            new VoicePermissionsWorker(rootGroup.RegionID)
            {
                Type = VoicePermissionsWorkerType.MemberRoleChanged,
                UserID = userID,
                RootGroup = rootGroup,
            }.Enqueue();
        }

        public static void CreateChannelPermissionsChanged(Group channel)
        {
            var root = channel.RootGroup;
            new VoicePermissionsWorker(root.RegionID)
            {
                Type = VoicePermissionsWorkerType.ChannelPermissionsChanged,
                Channel = channel,
                RootGroup = root,
            }.Enqueue();
        }

        public static void CreateRolePermissionsChanged(Group rootGroup)
        {
            new VoicePermissionsWorker(rootGroup.RegionID)
            {
                Type = VoicePermissionsWorkerType.RolePermissionsChanged,
                RootGroup = rootGroup,
            }.Enqueue();
        }
    }
}
