﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.CloudSearch;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search
{
    [CloudSearchModel(IndexTypeName = "externalcommunities", UseDefaultIndex = false, AutoCreateIndex = false)]
    [ElasticType(Name = "externalCommunity", IdProperty = "id")]
    public class ExternalCommunitySearchModel
    {
        public ExternalCommunitySearchModel()
        {
            
        }

        public ExternalCommunitySearchModel(ExternalCommunity community)
        {
            ID = string.Join(":",community.Type, community.ExternalID);
            Type = community.Type;
            ExternalID = community.ExternalID;
            ExternalName = community.ExternalName;
            ExternalDisplayName = community.ExternalDisplayName;
            AvatarUrl = community.AvatarUrl;
            ExternalStatus = community.ExternalStatus;
            ExternalGameName = community.ExternalGameName;
            IsLive = community.IsLive;
            LiveTimestamp = community.LiveTimestamp;
            Followers = community.Followers;
            Quality = (int) Math.Log(community.Followers + 1) * 2;

            var mappings = community.MappedGroups ?? new HashSet<Guid>();
            MappedGroups = mappings.Select(m => m.ToString()).ToArray();
        }

        [ElasticProperty(Name = "id", Type = FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public string ID { get; set; }

        [ElasticProperty(Name = "type", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public AccountType Type { get; set; }

        [ElasticProperty(Name = "externalId", Type = FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public string ExternalID { get; set; }

        [AnalyzedStringProperty("externalName", Autocomplete = true, Lowercase = true, Sortable = true)]
        public string ExternalName { get; set; }

        [AnalyzedStringProperty("externalDisplayName", Autocomplete = true, Lowercase = true, Sortable = true)]
        public string ExternalDisplayName { get; set; }

        [ElasticProperty(Name = "avatarUrl", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string AvatarUrl { get; set; }

        [ElasticProperty(Name = "externalStatus", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string ExternalStatus { get; set; }

        [AnalyzedStringProperty("externalGameName", Autocomplete = true, Sortable = true, Lowercase = true)]
        public string ExternalGameName { get; set; }

        [ElasticProperty(Name = "isLive", Type = FieldType.Boolean, Index = FieldIndexOption.NotAnalyzed)]
        public bool IsLive { get; set; }

        [ElasticProperty(Name="liveTimestamp", Type = FieldType.Long, Index = FieldIndexOption.NotAnalyzed)]
        public long LiveTimestamp { get; set; }

        [ElasticProperty(Name="mappedGroups", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string[] MappedGroups { get; set; }

        [ElasticProperty(Name = "followers", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int Followers { get; set; }

        [ElasticProperty(Name = "quality", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int Quality { get; set; }

        public ExternalCommunitySearchModelContract ToNotification(string urlFormatter)
        {
            return new ExternalCommunitySearchModelContract
            {
                Type = Type,
                ExternalID = ExternalID,
                ExternalName = ExternalName,
                ExternalDisplayName = ExternalDisplayName,
                AvatarUrl = AvatarUrl,
                ExternalGameName = ExternalGameName,
                ExternalStatus = ExternalStatus,
                IsLive = IsLive,
                LiveTimestamp = LiveTimestamp,
                ExternalUrl = string.Format(urlFormatter, ExternalName),
                Followers = Followers,
                SortRank = Quality
            };
        }
    }
}
