﻿using Curse.CloudSearch;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search.FriendSearch
{
    [CloudSearchModel(AutoCreateIndex = false, UseDefaultIndex = false, IndexTypeName = "characters", UseAlias = false)]
    [ElasticType(Name = "characterSearchModel", IdProperty = "uniqueKey")]
    public class CharacterFriendSearchModel : IUserSearchModel
    {
        public CharacterFriendSearchModel()
        {
            
        }

        public CharacterFriendSearchModel(int userID, string searchTerm, int gameID, string serverName, string serverRegion)
        {
            UserID = userID;
            SearchTerm = SanitizeSearchTerm(searchTerm);
            GameID = gameID;
            ServerName = serverName;
            ServerRegion = serverRegion;

            UniqueKey = "ID:" + userID + ";CharacterName:" + searchTerm + ";GameID:" + gameID + ";ServerName:" + (serverName ?? "None") + ";ServerRegion:" + (serverRegion ?? "None");
        }

        [ElasticProperty(Name = "uniqueKey", Type = FieldType.String, Index=FieldIndexOption.NotAnalyzed)]
        public string UniqueKey
        {
            get;
            set;
        }

        [AnalyzedStringProperty("searchTerm", Autocomplete = true, Sortable = true)]
        public string SearchTerm
        {
            get;
            set;
        }

        [ElasticProperty(Name = "characterName", Type = FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public string CharacterName
        {
            get;
            set;
        }

        [ElasticProperty(Name = "serverName", Type = FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public string ServerName
        {
            get;
            set;
        }

        [ElasticProperty(Name="serverRegion", Type = FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public string ServerRegion
        {
            get;
            set;
        }

        [ElasticProperty(Name="userId", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int UserID
        {
            get;
            set;
        }

        [ElasticProperty(Name="gameId", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int GameID
        {
            get;
            set;
        }

        [ElasticProperty(Name = "friendCount", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int FriendCount
        {
            get;
            set;
        }

        [ElasticProperty(Name = "description", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string Description
        {
            get;
            set;
        }

        [ElasticProperty(Name="avatarUrl", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string AvatarUrl
        {
            get;
            set;
        }

        public CharacterSearchContract ToNotification(double score, FriendshipRequestAvailability friendshipAvailability)
        {
            return new CharacterSearchContract
            {
                UserID = UserID,
                Score = score,
                AvatarUrl = AvatarUrl,
                CharacterName = CharacterName,
                Description = Description,
                FriendCount = FriendCount,
                GameID = GameID,
                SearchTerm = SearchTerm,
                ServerName = ServerName,
                ServerRegion = ServerRegion,
                UniqueKey = UniqueKey,
                FriendshipAvailability = friendshipAvailability
            };
        }

        public static string SanitizeSearchTerm(string original)
        {
            return original.ToLower().Replace(" ", string.Empty).Replace("_", string.Empty);
        }
    }
}
