﻿using Curse.CloudSearch;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search.FriendSearch
{
    [CloudSearchModel(IndexTypeName = "emails", AutoCreateIndex = false, UseDefaultIndex = false, UseAlias = false)]
    [ElasticType(Name = "emailSearchModel", IdProperty = "userId")]
    public class EmailFriendSearchModel : IUserSearchModel
    {
        [ElasticProperty(Name = "emailAddress", Type = FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public string EmailAddress
        {
            get;
            set;
        }

        [ElasticProperty(Name = "userId", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int UserID
        {
            get;
            set;
        }

        [ElasticProperty(Name = "friendCount", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int FriendCount
        {
            get;
            set;
        }

        [ElasticProperty(Name="avatarUrl", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string AvatarUrl
        {
            get;
            set;
        }

        [ElasticProperty(Name = "isMerged", Type = FieldType.Boolean, Index = FieldIndexOption.NotAnalyzed)]
        public bool IsMerged
        {
            get;
            set;
        }


        public EmailSearchContract ToNotification(double score, FriendshipRequestAvailability friendshipAvailability)
        {
            return new EmailSearchContract
            {
                FriendCount = FriendCount,
                UserID = UserID,
                Score = score,
                AvatarUrl = AvatarUrl,
                EmailAddress = EmailAddress,
                FriendshipAvailability = friendshipAvailability,
                IsMerged = IsMerged
            };
        }
    }
}
