﻿using Curse.CloudSearch;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search.FriendSearch
{
    [CloudSearchModel(IndexTypeName = "platforms", AutoCreateIndex = false, UseDefaultIndex = false, UseAlias = false)]
    [ElasticType(Name = "platformSearchModel", IdProperty = "uniqueKey")]
    public class PlatformFriendSearchModel : IUserSearchModel
    {
        public PlatformFriendSearchModel()
        {
            
        }

        public PlatformFriendSearchModel(int userID, string searchTerm, FriendPlatform platform)
        {
            UserID = userID;
            SearchTerm = searchTerm;
            Platform = platform;
            UniqueKey = "ID:" + userID + ";Identity:" + searchTerm + ";PlatformID:" + platform;
        }

        [AnalyzedStringProperty("searchTerm", Autocomplete = false, Sortable = true, Lowercase = true)]
        public string SearchTerm
        {
            get;
            set;
        }

        [ElasticProperty(Name = "identity", Type = FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public string Identity
        {
            get;
            set;
        }

        [ElasticProperty(Name="uniqueKey", Type = FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public string UniqueKey
        {
            get;
            set;
        }

        [ElasticProperty(Name="userId", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int UserID
        {
            get;
            set;
        }

        [ElasticProperty(Name = "platform", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public FriendPlatform Platform
        {
            get;
            set;
        }

        [ElasticProperty(Name = "visibility", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public FriendHintVisibility Visibility
        {
            get;
            set;
        }

        [ElasticProperty(Name = "friendCount", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int FriendCount
        {
            get;
            set;
        }

        [ElasticProperty(Name = "description", Type = FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public string Description
        {
            get;
            set;
        }

        [ElasticProperty(Name = "avatarUrl", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string AvatarUrl
        {
            get;
            set;
        }

        public PlatformSearchContract ToNotification(double score, FriendshipRequestAvailability friendshipAvailability)
        {
            return new PlatformSearchContract
            {
                AvatarUrl = AvatarUrl,
                FriendCount = FriendCount,
                Score = score,
                UserID = UserID,
                SearchTerm = SearchTerm,
                UniqueKey = UniqueKey,
                Description = Description,
                Identity = Identity,
                Platform = Platform,
                Visibility = Visibility,
                FriendshipAvailability = friendshipAvailability
            };
        }
    }
}
