﻿using Curse.CloudSearch;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search
{
    [CloudSearchModel(IndexTypeName = "usernames", AutoCreateIndex = false, UseDefaultIndex = false, UseAlias = false)]
    [ElasticType(Name = "usernameSearchModel", IdProperty = "userId")]
    public class UsernameFriendSearchModel
    {
        [AnalyzedStringProperty("username", Autocomplete = true, Sortable = true)]
        public string Username
        {
            get;
            set;
        }

        [ElasticProperty(Name = "userId", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int UserID
        {
            get;
            set;
        }

        [ElasticProperty(Name="friendCount", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int FriendCount
        {
            get;
            set;
        }

        [ElasticProperty(Name="avatarUrl", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string AvatarUrl
        {
            get;
            set;
        }

        [ElasticProperty(Name="isMerged", Type = FieldType.Boolean, Index = FieldIndexOption.NotAnalyzed)]
        public bool IsMerged
        {
            get; 
            set;
        }

        public UsernameSearchContract ToNotification(double score, FriendshipRequestAvailability friendshipAvailability, UserStatistics statistics)
        {
            return new UsernameSearchContract
            {
                UserID = UserID,
                AvatarUrl = AvatarUrl,
                FriendCount = FriendCount,
                Score = score,
                Username = Username,
                FriendshipAvailability = friendshipAvailability,
                IsMerged = IsMerged,
                DisplayName = statistics?.DisplayName,
            };
        }
    }
}
