﻿using System;
using Curse.CloudSearch;
using Curse.Extensions;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search
{
    [CloudSearchModel(AutoCreateIndex = false, UseDefaultIndex = false, IndexTypeName = "bannedusers")]
    [ElasticType(Name = "bannedUser", IdProperty = "modelId")]
    public class GroupBannedUserSearchModel
    {
        public GroupBannedUserSearchModel()
        {
            
        }

        public GroupBannedUserSearchModel(GroupBannedUser user)
        {
            ModelID = GetModelID(user.GroupID, user.UserID);
            GroupID = user.GroupID;
            UserID = user.UserID;
            Username = user.Username;
            Reason = user.Reason;
            IsDeleted = user.IsDeleted;
            StatusTimestamp = user.DateStatusChanged.ToEpochMilliseconds();
            RequestorUserID = user.RequestorID;
            RequestorUsername = user.RequestorUsername;
            IPAddress = user.IPAddress;
        }

        [ElasticProperty(Name = "modelId", Type = FieldType.String, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public string ModelID { get; set; }

        [ElasticProperty(Name = "groupId", Type = FieldType.String, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public Guid GroupID { get; set; }

        [ElasticProperty(Name = "userId", Type = FieldType.Integer, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public int UserID { get; set; }

        [AnalyzedStringProperty("username")]
        public string Username { get; set; }

        [ElasticProperty(Name = "requestorUserId", Type = FieldType.Integer, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public int RequestorUserID { get; set; }

        [AnalyzedStringProperty("requestorUsername")]
        public string RequestorUsername { get; set; }

        [ElasticProperty(Name = "statusTimestamp", Type = FieldType.Long, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public long StatusTimestamp { get; set; }

        [ElasticProperty(Name = "isDeleted", Type = FieldType.Boolean, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public bool IsDeleted { get; set; }

        [AnalyzedStringProperty("reason", Autocomplete = false)]
        public string Reason { get; set; }

        [ElasticProperty(Name="ipAddress", Type = FieldType.String, Store = true, Index = FieldIndexOption.NotAnalyzed)]
        public string IPAddress { get; set; }

        public static string GetModelID(Guid groupID, int userID)
        {
            return groupID.ToString() + userID;
        }
    }
}
