﻿using System;
using System.Collections.Generic;
using Curse.CloudSearch;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search
{
    public class GroupEventChannel
    {
        [ElasticProperty(Name="channelId", Type=FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public Guid ChannelID { get; set; }

        [AnalyzedStringProperty("title")]
        public string Title { get; set; }

        [ElasticProperty(Name="messageOfTheDay", Type=FieldType.String, Index = FieldIndexOption.Analyzed)]
        public string MessageOfTheDay { get;set; }

        [ElasticProperty(Name="type", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public GroupType Type { get; set; }

        [ElasticProperty(Name="isPublic", Type = FieldType.Boolean, Index = FieldIndexOption.No)]
        public bool IsPublic { get; set; }

        [ElasticProperty(Name="accessRoles", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int[] AccessRoles { get; set; }

        [ElasticProperty(Name="roleId", Type=FieldType.Integer, Index = FieldIndexOption.No)]
        public int RoleID { get; set; }

        [ElasticProperty(Name="roleName", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string RoleName { get; set; }

        [ElasticProperty(Name="premissionsStates", Type = FieldType.Object, Index = FieldIndexOption.No)]
        public Dictionary<int, int> PermissionsStates { get; set; }

        [ElasticProperty(Name="mode", Type=FieldType.Integer, Index = FieldIndexOption.No)]
        public GroupMode Mode { get; set; }

        public GroupEventChannelContract ToContract()
        {
            return new GroupEventChannelContract
            {
                ChannelID = ChannelID,
                Type = Type,
                Title = Title,
                MessageOfTheDay = MessageOfTheDay,
                RoleID = RoleID,
                IsPublic = IsPublic,
                RoleName = RoleName,
                AccessRoles = AccessRoles,
                PermissionsStates = PermissionsStates,
                Mode = Mode
            };
        }

    }
}