using Curse.CloudSearch;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search
{
    public class GroupEventGiveaway
    {
        [ElasticProperty(Name = "giveawayId", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int GiveawayID { get; set; }

        [AnalyzedStringProperty("title")]
        public string Title { get; set; }

        [ElasticProperty(Name = "entries", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int Entries { get; set; }

        [ElasticProperty(Name = "rollNumber", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int RollNumber { get; set; }

        [ElasticProperty(Name = "rollStatus", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public GroupGiveawayRollStatus? RollStatus { get; set; }

        [ElasticProperty(Name = "winnerUserID", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int WinnerUserID { get; set; }

        [AnalyzedStringProperty("winnerUsername")]
        public string WinnerUsername { get; set; }

        [ElasticProperty(Name="winnerBestRoleID", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int WinnerBestRoleID { get; set; }

        [ElasticProperty(Name = "winnerBestRoleName", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string WinnerBestRoleName { get; set; }

        [ElasticProperty(Name = "winnerValidStatus", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public GroupGiveawayWinnerValidStatus? WinnerValidStatus { get; set; }

        public GroupEventGiveawayContract ToContract()
        {
            return new GroupEventGiveawayContract
            {
                Title = Title,
                GiveawayID = GiveawayID,
                RollNumber = RollNumber,
                Entries = Entries,
                RollStatus = RollStatus,
                WinnerUserID = WinnerUserID,
                WinnerUsername = WinnerUsername,
                WinnerBestRoleID = WinnerBestRoleID,
                WinnerBestRoleName = WinnerBestRoleName,
                WinnerValidStatus = WinnerValidStatus
            };
        }

    }
}