using Curse.CloudSearch;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search
{
    public class GroupEventLinkedCommunity
    {
        [ElasticProperty(Name="externalId", Type = FieldType.String, Index = FieldIndexOption.NotAnalyzed)]
        public string ExternalID { get; set; }

        [AnalyzedStringProperty("externalName")]
        public string ExternalName { get; set; }

        [ElasticProperty(Name="syncEmoticons", Type =  FieldType.Boolean, Index = FieldIndexOption.No)]
        public bool SyncEmoticons { get; set; }

        [ElasticProperty(Name="gracePeriodAction", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public SyncedMemberGracePeriodAction? GracePeriodAction { get; set; }

        [ElasticProperty(Name="gracePeriodDays", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int GracePeriodDays { get; set; }

        [ElasticProperty(Name="isStreaming", Type = FieldType.Boolean, Index = FieldIndexOption.No)]
        public bool IsStreaming { get; set; }

        public GroupEventLinkedCommunityContract ToContract()
        {
            return new GroupEventLinkedCommunityContract
            {
                ExternalID = ExternalID,
                ExternalName = ExternalName,
                IsStreaming = IsStreaming,
                GracePeriodDays = GracePeriodDays,
                GracePeriodAction = GracePeriodAction,
                SyncEmoticons = SyncEmoticons
            };
        }

    }
}