﻿using Curse.CloudSearch;
using Curse.Friends.Enums;
using Nest;

namespace Curse.Friends.Data.Search
{
    public class GroupEventLinkedGuild
    {
        [ElasticProperty(Name = "type", Index = FieldIndexOption.NotAnalyzed, Store = true, Type = FieldType.Integer)]
        public AccountType Type { get; set; }

        [ElasticProperty(Name="gameRegion", Index=FieldIndexOption.No, Type = FieldType.Integer)]
        public int GameRegion { get; set; }

        [ElasticProperty(Name="gameServer", Index=FieldIndexOption.No, Type=FieldType.String)]
        public string GameServer { get; set; }

        [AnalyzedStringProperty("name")]
        public string Name { get; set; }
    }
}
