﻿using Curse.CloudSearch;
using Curse.Friends.Data.DerivedModels;
using Curse.Friends.Enums;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search
{
    public class GroupEventMember
    {
        [ElasticProperty(Name="userId", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int UserID { get; set; }

        [AnalyzedStringProperty("username")]
        public string Username { get; set; }

        [ElasticProperty(Name="roleId", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int RoleID { get; set; }

        [ElasticProperty(Name="roleName", Type=FieldType.String, Index = FieldIndexOption.No)]
        public string RoleName { get; set; }

        [ElasticProperty(Name="removedReason", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public GroupMemberRemovedReason? RemovedReason { get; set; }

        [ElasticProperty(Name = "removedMessage", Type = FieldType.String, Index = FieldIndexOption.No)]
        public string RemovedMessage { get; set; }

        public GroupEventUserContract ToContract()
        {
            return new GroupEventUserContract
            {
                Username = Username,
                UserID = UserID,
                RoleID = RoleID,
                RoleName = RoleName,
                RemovedMessage = RemovedMessage,
                RemovedReason = RemovedReason
            };
        }
    }
}