using Curse.CloudSearch;
using Curse.Friends.NotificationContracts;
using Nest;

namespace Curse.Friends.Data.Search
{
    public class GroupEventPoll
    {
        [ElasticProperty(Name = "pollId", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int PollID { get; set; }

        [AnalyzedStringProperty("title")]
        public string Title { get; set; }

        [ElasticProperty(Name = "totalVotes", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int TotalVotes { get; set; }

        [ElasticProperty(Name = "requiredRoles", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int[] RequiredRoles { get; set; }

        [ElasticProperty(Name = "optionsCount", Type = FieldType.Integer, Index = FieldIndexOption.NotAnalyzed)]
        public int OptionsCount { get; set; }

        [AnalyzedStringProperty("winningOptions")]
        public string[] WinningOptions { get; set; }

        [ElasticProperty(Name = "durationMinutes", Type = FieldType.Integer, Index = FieldIndexOption.No)]
        public int DurationMinutes { get; set; }

        public GroupEventPollContract ToContract()
        {
            return new GroupEventPollContract
            {
                Title = Title,
                RequiredRoles = RequiredRoles,
                PollID = PollID,
                DurationMinutes = DurationMinutes,
                OptionsCount = OptionsCount,
                TotalVotes = TotalVotes,
                WinningOptions = WinningOptions
            };
        }

    }
}